﻿var caseFilter = {
    context: $(".v-caseFilter"),
    showKeywordFilter: false,
    isForCallbacks: false,
    keywords: null,
    keywordsQuestion: null,
    keywordsNotRecoded: false,
    initializeInputs: function () {
        $(".h-autonumeric", this.context).autoNumeric({ aPad: false, mDec: '0', vMin: '0' });
        $(".h-datepicker", this.context).datepicker();
        $(".h-timepicker", this.context).timepicker();
    },
    initialize: function () {
        caseFilter.initializeInputs();

        caseFilter.showKeywordFilter = ($("#ShowKeywordFilter", caseFilter.context).val().toLowerCase() == "true");
        caseFilter.isForCallbacks = ($("#UseDateRangeSeparateTime", caseFilter.context).val().toLowerCase() == "true");
        caseFilter.initializeAutoCompletes();
        caseFilter.initializeCaseFilterAutoComplete();
        caseFilter.initializeKewyordFilter();

        $(".filter-section-content", caseFilter.context).each(function () {
            caseFilter.toggleCheckAll($(this));
        });
    },
    initializeKewyordFilter: function () {
        if (caseFilter.showKeywordFilter) {
            $(".v-keywordFilter .v-dynamicEditor", this.context).a4dynamicGrid({
                addRow: function (e, d) {
                    caseFilter.setKeywordAutoComplete($(".v-keyword", d.item), d.item);
                },
                rowReady: function (e, d) {
                    caseFilter.setKeywordAutoComplete($(".v-keyword", d.item), d.item);
                }
            });
        }
    },
    toggleButtons: function (enabled) {
        $(".h-saveCaseFilter", caseFilter.context).attr("disabled", true).prop("disabled", enabled);
        $(".h-loadCaseFilter", caseFilter.context).attr("disabled", true).prop("disabled", enabled);
        $(".h-deleteCaseFilter", caseFilter.context).attr("disabled", true).prop("disabled", enabled);
    },
    toggleCheckAll: function (section) {        
        var isChecked = $(":checkbox:not(.h-checkAll)", section).length == $(":checkbox:not(.h-checkAll):checked", section).length;
        $(".h-checkAll", section).prop("checked", isChecked);
    },
    bindEvents: function () {
        caseFilter.context.on("change", ".h-checkAll", function () {
            var section = $(this).closest(".filter-section-content");
            $(":checkbox", section).prop("checked", $(this).prop("checked"));
        });

        caseFilter.context.on("change", ":checkbox:not(.h-checkAll)", function () {
            caseFilter.toggleCheckAll($(this).closest(".filter-section-content"));
        });

        caseFilter.context.on("change", ".h-UseCurrentDateForStartCallBack", function () {
            if ($(this, this.context).is(':checked')) {
                $("#CallBackDateTimeFromDateDisplay", this.context).attr("disabled", true).prop("disabled", true);
                $("#CallBackDateTimeFromTimeDisplay", this.context).attr("disabled", true).prop("disabled", true);
                caseFilter.toggleCallbackTreadtedSeperatlyCheckbox();
            } else {
                $("#CallBackDateTimeFromDateDisplay", this.context).attr("disabled", false).prop("disabled", false);
                $("#CallBackDateTimeFromTimeDisplay", this.context).attr("disabled", false).prop("disabled", false);
                caseFilter.toggleCallbackTreadtedSeperatlyCheckbox();
            }
        });

        caseFilter.context.on("change", ".h-UseCurrentDateForEndCallBack", function () {
            if ($(this, this.context).is(':checked')) {
                $("#CallBackDateTimeToDateDisplay", this.context).attr("disabled", true).prop("disabled", true);
                $("#CallBackDateTimeToTimeDisplay", this.context).attr("disabled", true).prop("disabled", true);
                caseFilter.toggleCallbackTreadtedSeperatlyCheckbox();
            } else {
                $("#CallBackDateTimeToDateDisplay", this.context).attr("disabled", false).prop("disabled", false);
                $("#CallBackDateTimeToTimeDisplay", this.context).attr("disabled", false).prop("disabled", false);
                caseFilter.toggleCallbackTreadtedSeperatlyCheckbox();
            }
        });

        caseFilter.context.on("change", ".h-UseCurrentDateForStartLastCall", function () {
            if ($(this, this.context).is(':checked')) {
                $("#LastCallDateTimeStartDateDisplay", this.context).attr("disabled", true).prop("disabled", true);
                $("#LastCallDateTimeStartTimeDisplay", this.context).attr("disabled", true).prop("disabled", true);
                caseFilter.toggleLastCallTreadtedSeperatlyCheckbox();
            } else {
                $("#LastCallDateTimeStartDateDisplay", this.context).attr("disabled", false).prop("disabled", false);
                $("#LastCallDateTimeStartTimeDisplay", this.context).attr("disabled", false).prop("disabled", false);
                caseFilter.toggleLastCallTreadtedSeperatlyCheckbox();
            }
        });

        caseFilter.context.on("change", ".h-UseCurrentDateForEndLastCall", function () {
            if ($(this, this.context).is(':checked')) {
                $("#LastCallDateTimeEndDateDisplay", this.context).attr("disabled", true).prop("disabled", true);
                $("#LastCallDateTimeEndTimeDisplay", this.context).attr("disabled", true).prop("disabled", true);
                caseFilter.toggleLastCallTreadtedSeperatlyCheckbox();
            } else {
                $("#LastCallDateTimeEndDateDisplay", this.context).attr("disabled", false).prop("disabled", false);
                $("#LastCallDateTimeEndTimeDisplay", this.context).attr("disabled", false).prop("disabled", false);
                caseFilter.toggleLastCallTreadtedSeperatlyCheckbox();
            }
        });

        caseFilter.context.on("click", ".h-loadCaseFilter", function () {
            caseFilter.populateCaseFilterView();
        });

        caseFilter.context.on("click", ".h-saveCaseFilter", function () {
            var name = $(".h-caseFilterSavedFilters-autocomplete", caseFilter.context).val();
            var filterId = $("#FilterId", caseFilter.context).val();

            if (name) {
                if (filterId == "" || filterId == "0") {
                    caseFilter.saveCaseFilter();
                }
                else {
                    modalDialog.showConfirmDialog(confirmOverwriteCaseFilterResources, function () {
                        caseFilter.saveCaseFilter();
                    }, 220, 500, false, { "name": name });
                }
            }
        });

        caseFilter.context.on("click", ".h-deleteCaseFilter", function () {
            var id = $("#FilterId", caseFilter.context).val();
            var filterTitle = $("#FilterTitle", caseFilter.context).val();

            if (id == "" || id == "0")
                return;

            modalDialog.showConfirmDialog(confirmDeleteCaseFilterResources, function () {
                a4.callServerMethod(a4.getProjectAction("DeleteCaseFilter", "CaseFilters"), { caseFilterId: id, title: filterTitle },
                    function (result) {
                        caseFilter.clearCaseFilterCache();
                        caseFilter.initializeCaseFilterAutoComplete();

                        $("#FilterId", caseFilter.context).val("");

                        if (result.message)
                            a4.showSuccessMessage(result.message, 2500)
                    });
            }, 250, 500, true, { "name": $(".h-caseFilterSavedFilters-autocomplete", caseFilter.context).val() });
        });

        caseFilter.context.on("click", ".h-caseFilterTypeSelector li", function () {
            var typeSelector = $(this).closest(".h-caseFilterTypeSelector");
            var container = typeSelector.parent();
            var contentEditor = $(this).attr("data-editor");

            $("li.selected", typeSelector).removeClass("selected");
            $(this).addClass("selected");

            container.children(".v-contentContainer").hide();
            $(".v-contentContainer[data-editor='" + contentEditor + "']", container).show();

            // Get a default keyword if we don't have one
            if (contentEditor === "tabs-4" && !caseFilter.keywords) {
                $(".h-addRow").trigger('click');
            }
        });

        // Delete row
        caseFilter.context.on("click", ".v-keywordEditor .h-deleteLogicRow", function () {
            var editor = $(this).closest(".v-keywordEditor");
            var item = $(this).closest("tr");
            item.addClass("deleted").hide();

            if ($('.v-keywordTable tbody tr:not(.deleted)', editor).length == 0) {
                $('.v-keywordTable', editor).hide();
            }
        });
    },
    setKeywordAutoComplete: function (item, row) {
        if (caseFilter.keywords) {
            caseFilter.completeKeywordAutoComplete(item, row);
        }
        else {
            $.when(a4.callServerMethod(a4.getProjectAction("GetOpenEndKeywords", "Data", { questionName: caseFilter.keywordsQuestion, notRecoded: caseFilter.keywordsNotRecoded }))).then(function (result) {
                var list = [];

                _.each(result, function (r, v) {
                    list.push({ value: v })
                });

                caseFilter.keywords = list;
                caseFilter.completeKeywordAutoComplete(item, row);
            });
        }
    },
    completeKeywordAutoComplete: function (item, row) {
        item.a4autocomplete({
            data: caseFilter.keywords,
            valueProperty: "value",
            labelProperty: "value",
            validateSelection: false,
            multipleSelection: true,
            displaySeparator: " " + sharedResources.OR.toUpperCase() + " ",
            hideSelectedItems: true
        });
    },
    saveCaseFilter: function () {
        var filter = caseFilter.getFilterObject();
        var filterTitle = $("#FilterTitle", caseFilter.context).val();
        var filterId = parseInt($("#FilterId", caseFilter.context).val(), 10);
        caseFilter.toggleButtons(true);

        a4.callServerMethod(a4.getProjectAction("EditCaseFilter", "CaseFilters"), { model: filter },
            function (result) {
                caseFilter.clearCaseFilterCache();
                caseFilter.initializeCaseFilterAutoComplete();

                $(".h-caseFilterSavedFilters-autocomplete", caseFilter.context).val(filterTitle);
                $("#FilterId", caseFilter.context).val(result.filterId);
                $("#FilterTitle", caseFilter.context).val(filterTitle);
                caseFilter.toggleButtons(false);

                if (result.message) {
                    a4.showSuccessMessage(result.message, 2500)
                }
            }, function (error) {
                a4.showErrorMessage(error);
                caseFilter.toggleButtons(false);
            });
    },
    populateCaseFilterView: function () {
        var filterTitle = $('#FilterTitle').val();
        var filterId = $('#FilterId').val();

        if (filterId == "" || filterId == "0")
            return;

        caseFilter.toggleButtons(true);

        a4.callServerMethod(a4.getProjectAction("GetCaseFilter", "CaseFilters"), { "filterId": $("#FilterId").val(), "showKeywordFilter": caseFilter.showKeywordFilter },
            function (result) {
                if (result) {
                    $(".case-filter").html(result);

                    caseFilter.initializeInputs();
                    caseFilter.initializeAutoCompletes();
                    caseFilter.initializeCaseFilterAutoComplete();
                    caseFilter.initializeKewyordFilter();

                    $(".filter-section-content", caseFilter.context).each(function () {
                        caseFilter.toggleCheckAll($(this));
                    });

                    $(".h-caseFilterSavedFilters-autocomplete", caseFilter.context).val(filterTitle);
                    $("#FilterId", caseFilter.context).val(filterId);
                    $("#FilterTitle", caseFilter.context).val(filterTitle);
                    caseFilter.toggleButtons(false);
                }
            });
    },

    getFilterObject: function () {
        var filter = {};

        filter.IsValid = true;
        filter.Count = 0;
        filter.Summary = "";
        filter.ProjectId = $("#ProjectId").val() || 0;
        filter.FilterId = $("#FilterId").val() || 0;
        filter.FilterTitle = $(".h-caseFilterSavedFilters-autocomplete", this.context).val();
        filter.CaseFilterType = $("#CaseFilterType", this.context).val();
        filter.InterviewerIds = $("#InterviewerIds", this.context).val();
        filter.ResultCodes = $("#ResultCodes", this.context).val();
        filter.LastCallResultCodes = $("#LastCallResultCodes", this.context).val();
        filter.Languages = $(':input[name="LanguagesList"]:checked', this.context).map(function () { return this.value; }).get().join(',');
        filter.UseCurrentDateForStartCallBack = $('#UseCurrentDateForStartCallBack', this.context).is(":checked");
        filter.CallBackDateTimeFromDate = $('#CallBackDateTimeFromDateDisplay', this.context).val();
        filter.CallBackDateTimeFromTime = $('#CallBackDateTimeFromTimeDisplay', this.context).val();
        filter.UseCurrentDateForEndCallBack = $('#UseCurrentDateForEndCallBack', this.context).is(":checked");
        filter.CallBackDateTimeToDate = $('#CallBackDateTimeToDateDisplay', this.context).val();
        filter.CallBackDateTimeToTime = $('#CallBackDateTimeToTimeDisplay', this.context).val();
        filter.IsCallbackDateTimeTreatedSeperatly = $('#IsCallbackDateTimeTreatedSeperatly', this.context).is(":checked");
        filter.UseCurrentDateForStartLastCall = $('#UseCurrentDateForStartLastCall', this.context).is(":checked");
        filter.LastCallDateTimeStartDate = $('#LastCallDateTimeStartDateDisplay', this.context).val();
        filter.LastCallDateTimeStartTime = $('#LastCallDateTimeStartTimeDisplay', this.context).val();
        filter.UseCurrentDateForEndLastCall = $('#UseCurrentDateForEndLastCall', this.context).is(":checked");
        filter.LastCallDateTimeEndDate = $('#LastCallDateTimeEndDateDisplay', this.context).val();
        filter.LastCallDateTimeEndTime = $('#LastCallDateTimeEndTimeDisplay', this.context).val();
        filter.IsLastCallDateTimeTreadtedSeperatly = $('#IsLastCallDateTimeTreadtedSeperatly', this.context).is(":checked");
        filter.RespondentCase = $(':input[name="RespondentCase"]:checked', this.context).val();
        filter.RespondentState = $(':input[name="RespondentState"]:checked', this.context).val();
        filter.TimeSlotMode = $(':input[name="TimeSlotMode"]:checked', this.context).val();
        filter.DialingMode = $(':input[name="DialingMode"]:checked', this.context).val();
        filter.LastDialingMode = $(':input[name="LastDialingMode"]:checked', this.context).val();
        filter.StrataEnum = $(':input[name="StrataEnum"]:checked', this.context).val();
        filter.CyclePhoneNumber = $(':input[name="CyclePhoneNumber"]:checked', this.context).val();
        filter.Location = $(':input[name="Location"]:checked', this.context).val();
        filter.LinkedToA4S = $(':input[name="LinkedToA4S"]:checked', this.context).val();
        filter.IsNotInClosedStrata = $('#StrataEnum_OpenOnly', this.context).is(":checked");
        filter.IsAnonymized = this.getAnonymizedFilterValue();
        filter.Equation = $("#Equation", this.context).val();
        filter.MaxRecords = $("#MaxRecords", this.context).val();
        filter.TimeSlotId = $("#TimeSlotId", this.context).val();
        filter.TimeSlotOperator = $("#TimeSlotOperatorDropDownList", this.context).val();
        filter.TimeSlotHitCount = $("#TimeSlotHitCount", this.context).val();

        if (caseFilter.keywordsQuestion) {
            var conditions = [];

            $(".v-keywordFilter input.v-keyword:visible", this.context).each(function () {
                var cond = a4.getInputValue($(this));

                if (cond && cond.length > 0) {
                    conditions.push(cond.join(" OR "));
                }
            });

            filter.KeywordFilter = conditions;
        }

        return filter;
    },
    getAnonymizedFilterValue : function() {
        var value = null;
        if ($('input[name="IsAnonymized"]:checked', this.context).val() == "Anonymized")
            value = true;
        else if ($('input[name="IsAnonymized"]:checked', this.context).val() == "NonAnonymized")
            value = false;
        return value;
    },
    getCaseFilter: function (callback) {
        var filter = caseFilter.getFilterObject();

        a4.callServerMethod(a4.getProjectAction("ValidateCaseFilter", "CaseFilters"), { caseFilter: filter },
            function (result) {
                filter.IsValid = result.IsValid;
                filter.Count = result.Count;
                
                $('#Equation', this.context).toggleClass("input-validation-error", !filter.IsValid);

                if (callback) {
                    callback(filter, result.Summary);
                }
            },
            function (error) {}, { blockElement: caseFilter.context });
    },
    clearCaseFilterCache: function () {
        $(".h-caseFilterSavedFilters-autocomplete", this.context).a4autocomplete("clearCache");
    },
    initializeCaseFilterAutoComplete: function () {
        $(".h-caseFilterSavedFilters-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetCaseFiltersForAutoComplete", "CaseFilters"),
            multipleSelection: false,
            validateSelection: false,
            valueProperty: "FilterId",
            labelProperty: "FilterTitle",
            altValueField: $("#FilterId"),
            select: function (event, data) {
                $("#FilterTitle", caseFilter.context).val(data.item.FilterTitle);
                $("#FilterId", caseFilter.context).val(!isNaN(parseFloat(data.item.FilterId)) && isFinite(data.item.FilterId) ? data.item.FilterId : 0);
            }
        });

        $(".h-caseFilterSavedFilters-autocomplete", this.context).val("");
    },
    initializeAutoCompletes: function () {
        $(".h-caseFilterLastCallResultCodes-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetResultCodesForAutoComplete", "CallBacks"),
            valueProperty: "Id",
            labelProperty: "Name",
            multipleSelection: true,
            altValueField: $("#LastCallResultCodes"),
            hideSelectedItems: true
        });

        $(".h-caseFilterCaseResult-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetResultCodesForAutoComplete", "CallBacks"),
            valueProperty: "Id",
            labelProperty: "Name",
            multipleSelection: true,
            altValueField: $("#ResultCodes"),
            hideSelectedItems: true
        });

        $(".h-caseFilterInterviewers-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetCaseFilterInterviewersForAutoComplete", "CallBacks", { isCallback: caseFilter.isForCallbacks }),
            multipleSelection: true,
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#InterviewerIds"),
            hideSelectedItems: true
        });

        $(".h-caseFilterTimeSlots-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetTimeSlots", "CaseFilters"),
            tooltipProperty: "Tooltip",
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#TimeSlotId")
        });
    },
    clearCaseFilter: function () {
        $(".h-caseFilterInterviewers-autocomplete", this.context).a4autocomplete("clearValue");
        $(".h-caseFilterCaseResult-autocomplete", this.context).a4autocomplete("clearValue");
        $(".h-caseFilterLastCallResultCodes-autocomplete", this.context).a4autocomplete("clearValue");
        $(".h-caseFilterSavedFilters-autocomplete", this.context).a4autocomplete("clearValue");

        $(':input[name="LanguagesList"]:checked', this.context).prop("checked", false);
        $('#UseCurrentDateForStartCallBack', this.context).prop("checked", false);
        $('#CallBackDateTimeFromDateDisplay', this.context).val("");
        $('#CallBackDateTimeFromTimeDisplay', this.context).val("");
        $('#UseCurrentDateForEndCallBack', this.context).prop("checked", false);
        $('#CallBackDateTimeToDateDisplay', this.context).val("");
        $('#CallBackDateTimeToTimeDisplay', this.context).val("");
        $('#IsCallbackDateTimeTreatedSeperatly', this.context).prop("checked", false);
        $('#UseCurrentDateForStartLastCall', this.context).prop("checked", false);
        $('#LastCallDateTimeStartDateDisplay', this.context).val("");
        $('#LastCallDateTimeStartTimeDisplay', this.context).val("");
        $('#UseCurrentDateForEndLastCall', this.context).prop("checked", false);
        $('#LastCallDateTimeEndDateDisplay', this.context).val("");
        $('#LastCallDateTimeEndTimeDisplay', this.context).val("");
        $('#IsLastCallDateTimeTreadtedSeperatly', this.context).prop("checked", false);
        $(".h-checkAll", this.context).prop("checked", false);
                
        $(':input[name="RespondentCase"][value="All"]', this.context).prop("checked", true);
        $(':input[name="RespondentState"][value="All"]', this.context).prop("checked", true);
        $(':input[name="TimeSlotMode"][value="All"]', this.context).prop("checked", true);
        $(':input[name="DialingMode"][value="All"]', this.context).prop("checked", true);
        $(':input[name="LastDialingMode"][value="All"]', this.context).prop("checked", true);
        $(':input[name="StrataEnum"][value="All"]', this.context).prop("checked", true);
        $(':input[name="CyclePhoneNumber"][value="All"]', this.context).prop("checked", true);
        $(':input[name="Location"][value=""]', this.context).prop("checked", true);
        $(':input[name="LinkedToA4S"][value="All"]', this.context).prop("checked", true);

        $('#Equation', this.context).val("");
        $('#Equation', this.context).removeClass("input-validation-error");

        $("#CallBackDateTimeFromDateDisplay", this.context).attr("disabled", false).prop("disabled", false);
        $("#CallBackDateTimeFromTimeDisplay", this.context).attr("disabled", false).prop("disabled", false);
        $("#CallBackDateTimeToDateDisplay", this.context).attr("disabled", false).prop("disabled", false);
        $("#CallBackDateTimeToTimeDisplay", this.context).attr("disabled", false).prop("disabled", false);
        $("#LastCallDateTimeStartDateDisplay", this.context).attr("disabled", false).prop("disabled", false);
        $("#LastCallDateTimeStartTimeDisplay", this.context).attr("disabled", false).prop("disabled", false);
        $("#LastCallDateTimeEndDateDisplay", this.context).attr("disabled", false).prop("disabled", false);
        $("#LastCallDateTimeEndTimeDisplay", this.context).attr("disabled", false).prop("disabled", false);

        $(".h-caseFilterTimeSlots-autocomplete", this.context).a4autocomplete("clearValue");
        $("#TimeSlotOperatorDropDownList", this.context).val("Equals");
        $("#TimeSlotHitCount", this.context).val("");

        var kF = $(".v-keywordFilter .v-dynamicEditor", this.context);

        if (kF.length > 0)
            kF.a4dynamicGrid("clearValue");
    },
    toggleCallbackTreadtedSeperatlyCheckbox: function () {
        if ($("#UseCurrentDateForStartCallBack").is(":checked") == false && $("#UseCurrentDateForEndCallBack").is(":checked") == false)
            $("#IsCallbackDateTimeTreatedSeperatly", this.context).attr("disabled", false).prop("disabled", false);
        else
            $("#IsCallbackDateTimeTreatedSeperatly", this.context).attr("disabled", true).prop("disabled", true);
    },
    toggleLastCallTreadtedSeperatlyCheckbox: function () {
        if ($("#UseCurrentDateForStartLastCall").is(":checked") == false && $("#UseCurrentDateForEndLastCall").is(":checked") == false)
            $("#IsLastCallDateTimeTreadtedSeperatly", this.context).attr("disabled", false).prop("disabled", false);
        else
            $("#IsLastCallDateTimeTreadtedSeperatly", this.context).attr("disabled", true).prop("disabled", true);
    }
};

$(document).ready(function () {
    if (caseFilter.context.length > 0)
    {
        caseFilter.initialize();
        caseFilter.bindEvents();
    }
});